#!/usr/bin/perl

@files = </sys/block/sd*/stat>;

foreach $file (@files) {

  $device_name = substr ($file,11,3);

  open(DISKSTAT,$file);

  while (<DISKSTAT>) {

    if (/(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)$/) {
      $number_of_reads_completed= $1;
      $number_of_reads_merged = $2;
      $number_of_writes_merged = $6;
      $number_of_sectors_read = $3;
      $number_of_ms_reading = $4;
      $number_of_writes_completed = $5;
      $number_of_sectors_written = $7;
      $number_of_ms_writing = $8;
      $number_of_active_io_ops = $9;
      $number_of_ms_spent_doing_io_ops = $10;
      $whatever = $11;

    }

  }

  system("gmetric -n ${device_name}_reads_completed -u 'reads/sec' -d 60 --slope=positive --type int32 --value $number_of_reads_completed");
  system("gmetric -n ${device_name}_reads_merged -u 'merged reads/sec' -d 60 --slope=positive --type int32 --value $number_of_reads_merged");
  system("gmetric -n ${device_name}_writes_merged -u 'merged writes/sec' -d 60 --slope=positive --type int32 --value $number_of_writes_merged");
  system("gmetric -n ${device_name}_sectors_read -u 'sectors read/sec' -d 60 --slope=positive --type int32 --value $number_of_sectors_read");
  system("gmetric -n ${device_name}_ms_reading -u 'ms reading' -d 60 --slope=positive --type int32 --value $number_of_ms_reading");
  system("gmetric -n ${device_name}_writes_completed -u 'writes/sec' -d 60 --slope=positive --type int32 --value $number_of_writes_completed");
  system("gmetric -n ${device_name}_sectors_written -u 'sectors written/sec' -d 60 --slope=positive --type int32 --value $number_of_sectors_written");
  system("gmetric -n ${device_name}_ms_writing -u 'ms writing' -d 60 --slope=positive --type int32 --value $number_of_ms_writing");
  system("gmetric -n ${device_name}_active_io_ops -u'active io ops' -d 60 --slope=both --type int32 --value $number_of_active_io_ops");
  system("gmetric -n ${device_name}_ms_spent_doing_io_ops -u 'ms io ops' -d 60 --slope=positive --type int32 --value $number_of_ms_spent_doing_io_ops");

  close DISKSTAT;

}
