class twitch::crons::diskstats {
  include twitch::users::jtv

  $cronname = 'diskstats'

  cron { $cronname:
    ensure  => present,
    command => "/home/jtv/cronscripts/${cronname}.pl",
    user    => 'jtv',
    require => File["/home/jtv/cronscripts/${cronname}.pl"],
  }

  file { "/home/jtv/cronscripts/${cronname}.pl":
    ensure  => present,
    owner   => 'jtv',
    group   => 'jtv',
    mode    => '0755',
    source  => "puppet:///modules/twitch/crons/${cronname}.pl",
    require => Class['twitch::users::jtv'],
  }
}
