# Instance class to setup the default and global settings used in backend
# Creates stats listener on port set in class parameter stats_port (default 2015)
# Class parameter include_all (default true) will create a full catalog of backend listeners,
#  if set to false, individual listeners can be included to pare down the listing
class twitch::haproxy::backend (
  $instname    = 'backend',
  $stats_port  = 2015,
  $global_options = {
    'user'    => 'www-data',
    'group'   => 'www-data',
    'daemon'  => '',
    'quiet'   => '',
    'pidfile' => '/var/run/haproxy-backend.pid',
    'maxconn' => '32000',
    'chroot'  => '/var/chroot/haproxy',
    'nbproc'  => '1',
    'log-tag' => 'haproxy_backend',
    'log'     => '127.0.0.1 local3',
    'stats'   => 'socket /var/run/haproxy_backend.stat user root group root mode 666 level operator'
  },
  $defaults_options = {
    'log'     => 'global',
    'mode'    => 'tcp',
    'balance' => 'roundrobin',
    'option'  => [
      'tcplog',
      'tcpka',
      'redispatch',
      'contstats'
    ],
  },
  $include_all = true,
){

  $config_target = "/etc/haproxy/haproxy-${instname}.conf"

  twitch_haproxy::instance { $instname:
    svc_name         => $instname,
    defaults_options => $defaults_options,
    global_options   => $global_options,
    stats_port       => $stats_port,
  }

  if ($include_all) {
    include twitch::haproxy::listeners::backend_version
    include twitch::haproxy::listeners::backend_countess
    include twitch::haproxy::listeners::backend_database_sitedb_production_master
    include twitch::haproxy::listeners::backend_database_sitedb_production_master_sessionmode
    include twitch::haproxy::listeners::backend_database_sitedb_production_slave
    include twitch::haproxy::listeners::backend_database_sitedb_production_slave_sessionmode
    include twitch::haproxy::listeners::backend_database_sitedb_staging_master
    include twitch::haproxy::listeners::backend_database_sitedb_staging_master_sessionmode
    include twitch::haproxy::listeners::backend_database_sitedb_staging_slave
    include twitch::haproxy::listeners::backend_database_sitedb_staging_slave_sessionmode
    include twitch::haproxy::listeners::backend_database_sitedb_tmi_slave
    include twitch::haproxy::listeners::backend_database_sitedb_tmi_slave_sessionmode
    include twitch::haproxy::listeners::backend_rails_memcached_shard_a
    include twitch::haproxy::listeners::backend_rails_memcached_shard_b
    include twitch::haproxy::listeners::backend_usherdb_master
    include twitch::haproxy::listeners::backend_credentials_master
    include twitch::haproxy::listeners::backend_credentials_slave
    include twitch::haproxy::listeners::backend_network_master
    include twitch::haproxy::listeners::backend_stats_master
    include twitch::haproxy::listeners::backend_rabbit_cluster_site_staging
    include twitch::haproxy::listeners::backend_rabbit_cluster_site_staging_http_api
    include twitch::haproxy::listeners::backend_rabbit_cluster_video_production
    include twitch::haproxy::listeners::backend_rabbit_cluster_video_production_http_api
    include twitch::haproxy::listeners::backend_static_jtvfs
    include twitch::haproxy::listeners::backend_find_http
    include twitch::haproxy::listeners::backend_birdbot
    include twitch::haproxy::listeners::backend_owl
    include twitch::haproxy::listeners::backend_owl_staging
    include twitch::haproxy::listeners::backend_viewcount_usher
    include twitch::haproxy::listeners::backend_viewcount_postgres
    include twitch::haproxy::listeners::backend_xbox_plsso_internal
    include twitch::haproxy::listeners::backend_jax
    include twitch::haproxy::listeners::backend_flowsd_ams
    include twitch::haproxy::listeners::backend_flowsd_arn01
    include twitch::haproxy::listeners::backend_flowsd_cdg01
    include twitch::haproxy::listeners::backend_flowsd_dfw
    include twitch::haproxy::listeners::backend_flowsd_edgecast_asia
    include twitch::haproxy::listeners::backend_flowsd_edgecast_eu
    include twitch::haproxy::listeners::backend_flowsd_edgecast_na
    include twitch::haproxy::listeners::backend_flowsd_edgecast_latam
    include twitch::haproxy::listeners::backend_flowsd_fra
    include twitch::haproxy::listeners::backend_flowsd_iad02
    include twitch::haproxy::listeners::backend_flowsd_jfk
    include twitch::haproxy::listeners::backend_flowsd_l3
    include twitch::haproxy::listeners::backend_flowsd_lax
    include twitch::haproxy::listeners::backend_flowsd_lhr
    include twitch::haproxy::listeners::backend_flowsd_prg01
    include twitch::haproxy::listeners::backend_flowsd_sfo
    include twitch::haproxy::listeners::backend_flowsd_akamai_asia
    include twitch::haproxy::listeners::backend_flowsd_akamai_eu
    include twitch::haproxy::listeners::backend_flowsd_akamai_latam
    include twitch::haproxy::listeners::backend_flowsd_akamai_na
    include twitch::haproxy::listeners::backend_twitchtrace
    include twitch::haproxy::listeners::backend_flowsd_lhr02
    include twitch::haproxy::listeners::backend_flowsd_sjc01
    include twitch::haproxy::listeners::backend_flowsd_mia02
    include twitch::haproxy::listeners::backend_flowsd_sea01
    include twitch::haproxy::listeners::backend_videoshim
    include twitch::haproxy::listeners::backend_auditor
  }
}
