class twitch::haproxy::backends::countess (
  $haproxy_instance = 'countess',
  $proxy_name       = 'countess',
  $servers          = [
    'localhost',
  ],
  $remote_port      = 8080,
  $server_options   = 'check',
  $settings         = {
    'mode'   => 'http',
    'option' => [
      'httpchk GET /debug/health',
      'httpclose'
    ]
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::backend{ $proxy_name:
    config_target       => $config_target,
    default_remote_port => $remote_port,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
