class twitch::haproxy::backends::database_93_slave (
  $haproxy_instance = 'backend',
  $proxy_name     = 'database-93-slave',
  $servers        = [
    'rails-postgres-743a6c.sfo01.justin.tv:6542',
    'rails-postgres-743a6c.sfo01.justin.tv:6542',
    'rails-postgres-780e1d.sfo01.justin.tv:6542',
    'rails-postgres-780e1d.sfo01.justin.tv:6543',
    'rails-postgres-781339.sfo01.justin.tv:6542',
    'rails-postgres-781339.sfo01.justin.tv:6543',
    'rails-postgres-7c2299.sfo01.justin.tv:6542',
    'rails-postgres-7c2299.sfo01.justin.tv:6543',
    'rails-postgres-7c22a5.sfo01.justin.tv:6542',
    'rails-postgres-7c22a5.sfo01.justin.tv:6543',
    'rails-postgres-7e9d7d.sfo01.justin.tv:6542',
    'rails-postgres-7e9d7d.sfo01.justin.tv:6543',
    'rails-postgres-e2f994.sfo01.justin.tv:6542',
    'rails-postgres-e2f994.sfo01.justin.tv:6543',
    'rails-postgres-e39de0.sfo01.justin.tv:6542',
    'rails-postgres-e39de0.sfo01.justin.tv:6543',
    'rails-postgres-eb9296.sfo01.justin.tv:6542',
    'rails-postgres-eb9296.sfo01.justin.tv:6543',
    'rails-postgres-eb9796.sfo01.justin.tv:6542',
    'rails-postgres-eb9796.sfo01.justin.tv:6543',
    'rails-postgres-eb97e4.sfo01.justin.tv:6542',
    'rails-postgres-eb97e4.sfo01.justin.tv:6543',
  ],
  $remote_port    = 6542,
  $server_options = 'check inter 5000',
  $settings       = {
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::backend{ $proxy_name:
    config_target       => $config_target,
    default_remote_port => $remote_port,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }

}
