class twitch::haproxy::backends::flowsd_set2_fanout (
  $haproxy_instance = 'flowsd',
  $proxy_name       = 'flowsd-set2-fanout',
  $servers          = [
    'localhost:7012',
    'localhost:7013',
  ],
  $remote_port      = 7012,
  $server_options   = 'check inter 1000 maxconn 200 maxqueue 200',
  $settings         = {
    'mode'    => 'http',
    'option'  => [
      'httpchk HEAD /running',
    ],
    'timeout' => [
      'queue 500ms'
    ],
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::backend{ $proxy_name:
    config_target       => $config_target,
    default_remote_port => $remote_port,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
