class twitch::haproxy::backends::hls_edge_daemon_out (
  $haproxy_instance = 'hlsedge',
  $proxy_name       = 'hls-edge-daemon-out',
  $servers          = [
    'localhost:4555 fall 1 rise 2',
    'localhost:4556 backup',
  ],
  $remote_port      = 4555,
  $server_options   = 'check inter 1000',
  $settings         = {
    'mode'    => 'http',
    'option'  => [
      'httpchk HEAD /running',
    ],
    'timeout' => [
      'http-keep-alive 1000'
    ],
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::backend{ $proxy_name:
    config_target       => $config_target,
    default_remote_port => $remote_port,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
