class twitch::haproxy::backends::jax_handler (
  $haproxy_instance = 'jax',
  $proxy_name       = 'jax_handler',
  $servers          = [
    'localhost',
    'jax1.sfo01.justin.tv backup',
    'jax2.sfo01.justin.tv backup',
    'jax3.sfo01.justin.tv backup',
    'jax4.sfo01.justin.tv backup',
  ],
  $remote_port      = 6064,
  $server_options   = 'check inter 1000',
  $settings         = {
    'mode'   => 'http',
    'option' => [
      'httpchk GET /debug/health',
      'httpclose'
    ]
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::backend{ $proxy_name:
    config_target       => $config_target,
    default_remote_port => $remote_port,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
