class twitch::haproxy::backends::tenfoot_out($blue_listen_port, $green_listen_port) {
  validate_re($blue_listen_port, '^\d+$')
  validate_re($green_listen_port, '^\d+$')

  $haproxy_instance = 'tenfoot'
  $proxy_name = 'tenfoot-out'
  $servers = [
    "localhost:${blue_listen_port} fall 1 rise 2",
    "localhost:${green_listen_port} fall 1 rise 2",
  ]
  $remote_port = $blue_listen_port
  $server_options = 'check inter 1000'
  $settings = {
    'mode'    => 'http',
    'option'  => [
      'httpchk HEAD /running',
    ],
    'timeout' => [
      'http-keep-alive 1000'
    ],
  }

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::backend{ $proxy_name:
    config_target       => $config_target,
    default_remote_port => $remote_port,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }

  twitch_haproxy::backend { 'blue':
    config_target       => $config_target,
    default_remote_port => $blue_listen_port,
    server_list         => ["localhost:${blue_listen_port} fall 1 rise 2"],
    options             => $settings,
    server_options      => $server_options,
  }

  twitch_haproxy::backend { 'green':
    config_target       => $config_target,
    default_remote_port => $green_listen_port,
    server_list         => ["localhost:${green_listen_port} fall 1 rise 2"],
    options             => $settings,
    server_options      => $server_options,
  }
}
