class twitch::haproxy::backends::usher_origin (
  $instname,
  $ports,
  $proxy_name      = "${instname}-out",
  $server_options  = 'check inter 1000 maxconn 40 fall 1 rise 2',
  $settings        = {
    'mode'   => 'http',
    'option' => [
      'dontlog-normal',
      'httplog',
      'httpchk HEAD /running HTTP/1.0',
    ],
  },
) {
  $config_target = "/etc/haproxy/haproxy-${instname}.conf"

  $servers_string = inline_template('<%= @ports.map { |port| "localhost:#{port}"}.join(",") %>')
  $servers = split($servers_string, ',')

  twitch_haproxy::backend{ $proxy_name:
    config_target       => $config_target,
    default_remote_port => $remote_port,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
