class twitch::haproxy::backends::videoshim (
  $haproxy_instance = 'videoshim',
  $proxy_name       = 'videoshim-out',
  $servers          = [
    'shim-493af0.sfo01.justin.tv:5050 fall 1 rise 2',
    'shim-493af8.sfo01.justin.tv:5050 fall 1 rise 2',
    'shim-4b5e40.sfo01.justin.tv:5050 fall 1 rise 2',
  ],

  $api_internal_name = 'videoshim-api-internal',
  $api_internal_port = '80',
  $api_internal_servers = [
    'rails-nginx-493af2.sfo01.justin.tv fall 1 rise 2',
    'rails-nginx-5be184.sfo01.justin.tv fall 1 rise 2',
    'rails-nginx-5be1dc.sfo01.justin.tv fall 1 rise 2',
    'rails-nginx-68c0ac.sfo01.justin.tv fall 1 rise 2',
    'rails-nginx-68bbb4.sfo01.justin.tv fall 1 rise 2',
    'rails-nginx-6dad88.sfo01.justin.tv fall 1 rise 2',
    'rails-nginx-6db1a4.sfo01.justin.tv fall 1 rise 2',
    'rails-nginx-6db320.sfo01.justin.tv fall 1 rise 2',
    'rails-nginx-6db4c4.sfo01.justin.tv fall 1 rise 2',
    'rails-nginx-6db728.sfo01.justin.tv fall 1 rise 2',
    'rails-nginx-6dc75c.sfo01.justin.tv fall 1 rise 2',
    'rails-nginx-6f4e7c.sfo01.justin.tv fall 1 rise 2',
    'rails-nginx-7ecd62.sfo01.justin.tv fall 1 rise 2',
  ],

  $server_options = 'check inter 5000 maxconn 52000',

  $settings = {
    'mode'   => 'http',
    'option' => [
      'httpchk HEAD /running',
    ],
  },
  $api_settings = {
    'mode'          => 'http',
    'maxconn' => '100000',
    'option'        => [
      'httpchk HEAD /running HTTP/1.1\r\nHost:\ api.internal.twitch.tv',
      'http-server-close',
    ],
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::backend{ $proxy_name:
    config_target       => $config_target,
    default_remote_port => $remote_port,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }

  twitch_haproxy::backend{ $api_internal_name:
    config_target       => $config_target,
    default_remote_port => $api_internal_port,
    options             => $api_settings,
    server_list         => $api_internal_servers,
    server_options      => $server_options,
  }
}
