class twitch::haproxy::countess (
  $instname   = 'countess',
  $stats_port = 2001,
  $global_options = {
    'user'         => 'www-data',
    'group'        => 'www-data',
    'daemon'       => '',
    'quiet'        => '',
    'pidfile'      => '/var/run/haproxy-countess.pid',
    'maxconn'      => '4000',
    'chroot'       => '/var/chroot/haproxy',
    'nbproc'       => '1',
    'log-tag'      => 'haproxy_countess',
    'log'          => '127.0.0.1 local3',
    'stats'        => 'socket /var/run/haproxy-countess.stat user root group root mode 666 level operator',
  },
  $defaults_options = {
    'log'     => 'global',
    'balance' => 'roundrobin',
    'option'  => [
      'allbackups',
    ],
    'timeout' => [
      'connect 1000',
    ]
  },
){

  twitch_haproxy::instance { $instname:
    svc_name         => $instname,
    defaults_options => $defaults_options,
    global_options   => $global_options,
    stats_port       => $stats_port,
  }

  include twitch::haproxy::backends::countess
  include twitch::haproxy::frontends::countess_in
}
