class twitch::haproxy::flowsd (
  $instname   = 'flowsd',
  $stats_port = 2016,
  $global_options = {
    'user'         => 'www-data',
    'group'        => 'www-data',
    'daemon'       => '',
    'quiet'        => '',
    'pidfile'      => '/var/run/haproxy-flowsd.pid',
    'maxconn'      => '32000',
    'chroot'       => '/var/chroot/haproxy',
    'nbproc'       => '1',
    'log-tag'      => 'haproxy_flowsd',
    'log'          => '127.0.0.1 local3',
    'stats'        => 'socket /var/run/haproxy-flowsd.stat user root group root mode 666 level operator',
  },
  $defaults_options = {
    'log'     => 'global',
    'balance' => 'roundrobin',
    'option'  => [
      'tcplog',
      'tcpka',
      'redispatch',
      'contstats'
    ],
    'timeout' => [
      'connect 1000',
      'server 30000',
      'client 500'
    ]
  },
){

  twitch_haproxy::instance { $instname:
    svc_name         => $instname,
    defaults_options => $defaults_options,
    global_options   => $global_options,
    stats_port       => $stats_port,
  }

  include twitch::haproxy::frontends::flowsd_3700_check
  include twitch::haproxy::frontends::flowsd_3701_check
  include twitch::haproxy::frontends::flowsd_3702_check
  include twitch::haproxy::frontends::flowsd_3800_check
  include twitch::haproxy::frontends::flowsd_3801_check
  include twitch::haproxy::frontends::flowsd_3802_check
  include twitch::haproxy::frontends::flowsd_backup1_in
  include twitch::haproxy::frontends::flowsd_backup2_in
  include twitch::haproxy::frontends::flowsd_backup3_in
  include twitch::haproxy::frontends::flowsd_set1_in
  include twitch::haproxy::frontends::flowsd_set2_in
  include twitch::haproxy::frontends::flowsd_set3_in
  include twitch::haproxy::backends::flowsd_backup1_fanout
  include twitch::haproxy::backends::flowsd_backup2_fanout
  include twitch::haproxy::backends::flowsd_backup3_fanout
  include twitch::haproxy::backends::flowsd_set1_fanout
  include twitch::haproxy::backends::flowsd_set2_fanout
  include twitch::haproxy::backends::flowsd_set3_fanout
}
