class twitch::haproxy::frontends::countess_in (
  $haproxy_instance = 'countess',
  $proxy_name       = 'countess_in',
  $listen_port      = 6060,
  $listen_address   = '0.0.0.0',
  $settings         = {
    'mode'            => 'http',
    'default_backend' => 'countess',
    'rate-limit'      => 'sessions 2000',
    'option'          => [
      'dontlog-normal',
      'httpclose'
    ]
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::frontend{ $proxy_name:
    config_target       => $config_target,
    ports               => $listen_port,
    ipaddress           => $listen_address,
    options             => $settings,
  }
}
