class twitch::haproxy::frontends::flowsd_3700_check (
  $haproxy_instance = 'flowsd',
  $proxy_name       = '3700_check',
  $listen_port      = 37000,
  $listen_address   = '*',
  $settings         = {
    'mode'        => 'http',
    'monitor-uri' => '/alive',
    'acl'         => [
      '3700_dead nbsrv(flowsd-set1-fanout) lt 1',
    ],
    'monitor'     => [
      'fail if 3700_dead',
    ],
    'option'      => [
      'httplog',
    ],
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::frontend{ $proxy_name:
    config_target       => $config_target,
    ports               => $listen_port,
    ipaddress           => $listen_address,
    options             => $settings,
  }
}
