class twitch::haproxy::frontends::flowsd_3702_check (
  $haproxy_instance = 'flowsd',
  $proxy_name       = '3702_check',
  $listen_port      = 37020,
  $listen_address   = '*',
  $settings         = {
    'mode'        => 'http',
    'monitor-uri' => '/alive',
    'acl'         => [
      '3702_dead nbsrv(flowsd-set3-fanout) lt 1',
    ],
    'monitor'     => [
      'fail if 3702_dead',
    ],
    'option'      => [
      'httplog',
    ],
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::frontend{ $proxy_name:
    config_target       => $config_target,
    ports               => $listen_port,
    ipaddress           => $listen_address,
    options             => $settings,
  }
}
