class twitch::haproxy::frontends::flowsd_backup2_in (
  $haproxy_instance = 'flowsd',
  $proxy_name       = 'flowsd-backup2-in',
  $listen_port      = 3801,
  $listen_address   = '*',
  $settings         = {
    'default_backend' => 'flowsd-backup2-fanout',
    'mode'            => 'http',
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::frontend{ $proxy_name:
    config_target       => $config_target,
    ports               => $listen_port,
    ipaddress           => $listen_address,
    options             => $settings,
  }
}
