class twitch::haproxy::frontends::flowsd_backup3_in (
  $haproxy_instance = 'flowsd',
  $proxy_name       = 'flowsd-backup3-in',
  $listen_port      = 3802,
  $listen_address   = '*',
  $settings         = {
    'default_backend' => 'flowsd-backup3-fanout',
    'mode'            => 'http',
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::frontend{ $proxy_name:
    config_target       => $config_target,
    ports               => $listen_port,
    ipaddress           => $listen_address,
    options             => $settings,
  }
}
