class twitch::haproxy::frontends::flowsd_set3_in (
  $haproxy_instance = 'flowsd',
  $proxy_name       = 'flowsd-set3-in',
  $listen_port      = 3702,
  $listen_address   = '*',
  $settings         = {
    'default_backend' => 'flowsd-set3-fanout',
    'mode'            => 'http',
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::frontend{ $proxy_name:
    config_target       => $config_target,
    ports               => $listen_port,
    ipaddress           => $listen_address,
    options             => $settings,
  }
}
