class twitch::haproxy::frontends::jax_in (
  $haproxy_instance = 'jax',
  $proxy_name       = 'jax_in',
  $listen_port      = 8080,
  $listen_address   = '127.0.0.1',
  $settings         = {
    'mode'            => 'http',
    'default_backend' => 'jax_core',
    'option'          => [
      'dontlog-normal',
      'httpclose'
    ]
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::frontend{ $proxy_name:
    config_target       => $config_target,
    ports               => $listen_port,
    ipaddress           => $listen_address,
    options             => $settings,
  }
}
