class twitch::haproxy::frontends::jax_staging_handler_in (
  $haproxy_instance = 'jax',
  $proxy_name       = 'jax_staging_handler_in',
  $listen_port      = 8089,
  $listen_address   = '127.0.0.1',
  $settings         = {
    'mode'            => 'http',
    'default_backend' => 'jax_staging_handler',
    'option'          => [
      'dontlog-normal',
      'httpclose'
    ]
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::frontend{ $proxy_name:
    config_target       => $config_target,
    ports               => $listen_port,
    ipaddress           => $listen_address,
    options             => $settings,
  }
}
