class twitch::haproxy::frontends::telegraph_frontend (
  $haproxy_instance = 'telegraph',
  $proxy_name       = 'telegraph-frontend',
  $listen_port      = ['7770','443','80','1935'],
  $listen_address   = '0.0.0.0',
  $settings         = {
    'default_backend' => 'telegraph-backend',
    'maxconn'         => '1000000',
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::frontend{ $proxy_name:
    config_target       => $config_target,
    ports               => $listen_port,
    ipaddress           => $listen_address,
    options             => $settings,
  }
}
