class twitch::haproxy::frontends::tenfoot_in($listen_port) {
  validate_re($listen_port, '^\d+$')

	$haproxy_instance = 'tenfoot'
	$proxy_name = 'tenfoot-in'
	$listen_address = '0.0.0.0'
	$settings         = {
    'default_backend' => 'tenfoot-out',
    'mode'            => 'http',
    'timeout'         => [
      'http-request 1000',
      'http-keep-alive 10000',
    ],
    'acl'            => [
      'is_local src localhost',
      'is_green hdr(X-Twitch-Force) -i green',
      'is_blue hdr(X-Twitch-Force) -i blue',
    ],
    'use_backend'    => [
      'green if is_green is_local',
      'blue if is_blue is_local',
    ]
  }

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::frontend{ $proxy_name:
    config_target       => $config_target,
    ports               => $listen_port,
    ipaddress           => $listen_address,
    options             => $settings,
  }
}
