class twitch::haproxy::frontends::usher_origin (
  $instname,
  $proxy_name       = "${instname}-in",
  $listen_port,
  $listen_address   = '*',
  $settings         = {
    'default_backend' => "${instname}-out",
    'mode'            => 'http',
  },
) {

  $config_target = "/etc/haproxy/haproxy-${instname}.conf"

  # Temporary solution for migration of viewcounts from the old port.
  if $instname == 'viewcount-origin' {
    $ports = [$listen_port, 8100]
  } else {
    $ports = $listen_port
  }

  twitch_haproxy::frontend{ $proxy_name:
    config_target => $config_target,
    ports         => $ports,
    ipaddress     => $listen_address,
    options       => $settings,
  }
}
