class twitch::haproxy::frontends::usher_origin_check (
  $instname,
  $min_backends,
  $proxy_name       = "${instname}-check",
  $listen_port      = 8001,
  $listen_address   = '*',
  $settings         = {
    'mode'        => 'http',
    'monitor-uri' => '/alive',
    'acl'         => [
      "usher_origin_dead nbsrv(${instname}-out) lt ${min_backends}",
    ],
    'monitor' => [
      'fail if usher_origin_dead',
    ],
    'option' => [
      'httplog',
    ],
  },
) {

  $config_target = "/etc/haproxy/haproxy-${instname}.conf"

  # Temporary solution for migration of viewcounts from the old port.
  if $instname == 'viewcount-origin' {
    $old_settings = {
      'mode'        => 'http',
      'monitor-uri' => '/viewcount_usher_alive',
      'acl'         => [
        "usher_origin_dead nbsrv(${instname}-out) lt 1",
      ],
      'monitor' => [
        'fail if usher_origin_dead',
      ],
      'option' => [
        'httplog',
      ],
    }

    twitch_haproxy::frontend{ 'viewcount-origin-old-port-check':
      config_target => $config_target,
      ports         => 8101,
      ipaddress     => $listen_address,
      options       => $old_settings,
    }
  }

  twitch_haproxy::frontend{ $proxy_name:
    config_target => $config_target,
    ports         => $listen_port,
    ipaddress     => $listen_address,
    options       => $settings,
  }
}
