class twitch::haproxy::frontends::videoshim (
  $haproxy_instance = 'videoshim',
  $proxy_name       = 'videoshim-in',
  $listen_port      = 5151,
  $listen_address   = '*',
  $settings         = {
    'default_backend' => 'videoshim-out',
    'mode'            => 'http',
  },
  $api_proxy_name       = 'videoshim-api-internal',
  $api_listen_port      = 4040,
  $api_listen_address   = '127.0.0.1',
  $api_settings         = {
    'default_backend' => 'videoshim-api-internal',
    'mode'            => 'http',
    'reqidel'         => '^Host:.*',
    'reqadd'          => 'Host:\ api.internal.twitch.tv',
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::frontend{ $proxy_name:
    config_target => $config_target,
    ports         => $listen_port,
    ipaddress     => $listen_address,
    options       => $settings,
  }

  twitch_haproxy::frontend{ $api_proxy_name:
    config_target => $config_target,
    ports         => $api_listen_port,
    ipaddress     => $api_listen_address,
    options       => $api_settings,
  }

}
