class twitch::haproxy::frontends::videoshim_check (
  $haproxy_instance = 'videoshim',
  $proxy_name       = 'videoshim-check',
  $listen_port      = 35151,
  $listen_address   = '*',
  $settings         = {
    'mode'        => 'http',
    'monitor-uri' => '/alive',
    'acl'         => [
      'videoshim_dead nbsrv(videoshim-out) lt 1',
    ],
    'monitor' => [
      'fail if videoshim_dead',
    ],
    'option' => [
      'httplog',
    ],
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::frontend{ $proxy_name:
    config_target => $config_target,
    ports         => $listen_port,
    ipaddress     => $listen_address,
    options       => $settings,
  }
}
