class twitch::haproxy::hlsedge (
  $instname   = 'hlsedge',
  $stats_port = 2017,
  $global_options = {
    'user'         => 'www-data',
    'group'        => 'www-data',
    'daemon'       => '',
    'quiet'        => '',
    'pidfile'      => '/var/run/haproxy-hlsedge.pid',
    'maxconn'      => '4000',
    'chroot'       => '/var/chroot/haproxy',
    'nbproc'       => '2',
    'log-tag'      => 'haproxy_hlsedge',
    'log'          => '127.0.0.1 local3',
    'stats'        => 'socket /var/run/haproxy-hlsedge.stat user root group root mode 666 level operator',
  },
  $defaults_options = {
    'log'     => 'global',
    'balance' => 'roundrobin',
    'option'  => [
      'redispatch',
    ],
    'timeout' => [
      'queue 500',
    ]
  },
){

  twitch_haproxy::instance { $instname:
    svc_name         => $instname,
    defaults_options => $defaults_options,
    global_options   => $global_options,
    stats_port       => $stats_port,
  }

  include twitch::haproxy::frontends::hls_edge_daemon_in
  include twitch::haproxy::backends::hls_edge_daemon_out
}
