class twitch::haproxy::hlsorigin (
  $instname   = 'hlsorigin',
  $stats_port = 2001,
  $global_options = {
    'user'         => 'www-data',
    'group'        => 'www-data',
    'daemon'       => '',
    'quiet'        => '',
    'pidfile'      => '/var/run/haproxy-hlsorigin.pid',
    'maxconn'      => '32000',
    'chroot'       => '/var/chroot/haproxy',
    'nbproc'       => '1',
    'log-tag'      => 'haproxy_hlsorigin',
    'log'          => '127.0.0.1 local3',
    'stats'        => 'socket /var/run/haproxy-hlsorigin.stat user root group root mode 666 level operator',
  },
  $defaults_options = {
    'log'     => 'global',
    'balance' => 'roundrobin',
    'mode'    => 'tcp',
    'option'  => [
      'redispatch',
      'tcplog',
      'tcpka',
      'contstats',
    ],
    'timeout' => [
      'queue 500',
      'connect 1000',
      'client 5000',
      'server 1000',
    ]
  },
){

  twitch_haproxy::instance { $instname:
    svc_name         => $instname,
    defaults_options => $defaults_options,
    global_options   => $global_options,
    stats_port       => $stats_port,
  }

  include twitch::haproxy::listeners::hlsorigin_hls_reptree_origin
}
