class twitch::haproxy::jax (
  $instname = 'jax',
  $global_options = {
    'user'    => 'www-data',
    'group'   => 'www-data',
    'daemon'  => '',
    'quiet'   => '',
    'pidfile' => '/var/run/haproxy-jax.pid',
    'maxconn' => '32000',
    'chroot'  => '/var/chroot/haproxy',
    'nbproc'  => '1',
    'log-tag' => 'haproxy_jax',
    'log'     => '127.0.0.1 local3',
    'stats'   => 'socket /var/run/haproxy_jax.stat user root group root mode 666 level operator'
  },
  $defaults_options = {
    'log'     => 'global',
    'balance' => 'roundrobin',
    'option'  => [
      'allbackups',
      'tcplog',
      'tcpka',
      'redispatch',
      'contstats',
    ],
    'timeout' => [
      'connect 500',
      'server 5000',
      'client 5000'
    ]
  },
){

  twitch_haproxy::instance { $instname:
    svc_name         => $instname,
    defaults_options => $defaults_options,
    global_options   => $global_options,
  }

  include twitch::haproxy::frontends::jax_in
  include twitch::haproxy::frontends::jax_handler_in
  include twitch::haproxy::frontends::jax_staging_in
  include twitch::haproxy::frontends::jax_staging_handler_in
  include twitch::haproxy::backends::jax_core
  include twitch::haproxy::backends::jax_handler
  include twitch::haproxy::backends::jax_staging_core
  include twitch::haproxy::backends::jax_staging_handler
}
