class twitch::haproxy::listeners::backend_auditor (
  $haproxy_instance = 'backend',
  $proxy_name       = 'auditor',
  $servers          = [
    'auditor-7be3fe.sfo01.justin.tv',
    'auditor-7d9046.sfo01.justin.tv',
  ],
  $listen_port      = 12306,
  $remote_port      = 8080,
  $listen_address   = '127.0.0.1',
  $server_options   = 'check inter 5000',
  $settings         = {
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::listen{ $proxy_name:
    config_target       => $config_target,
    ports               => $listen_port,
    default_remote_port => $remote_port,
    ipaddress           => $listen_address,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
