class twitch::haproxy::listeners::backend_birdbot (
  $haproxy_instance = 'backend',
  $proxy_name     = 'birdbot',
  $servers        = ['job24.sfo01.justin.tv',
  ],
  $listen_port    = 12270,
  $remote_port    = 8876,
  $listen_address = '127.0.0.1',
  $server_options = 'check inter 5000',
  $settings       = {
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::listen{ $proxy_name:
    config_target       => $config_target,
    ports               => $listen_port,
    default_remote_port => $remote_port,
    ipaddress           => $listen_address,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options
  }
}
