class twitch::haproxy::listeners::backend_cohesion (
  $haproxy_instance = 'backend',
  $proxy_name     = 'cohesion',
  $servers        = [
    'cohesion-app-a0c27a.sfo01.justin.tv',
    'cohesion-app-a0c283.sfo01.justin.tv',
    'cohesion-app-a00094.sfo01.justin.tv',
    'cohesion-app-7ecb89.sfo01.justin.tv'
  ],
  $listen_port    = 12370,
  $remote_port    = 8000,
  $listen_address = '127.0.0.1',
  $server_options = 'check inter 5000',
  $settings       = {
    'mode' => 'http',
    'option' => [
        'httpchk GET /debug/running',
    ]
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::listen{ $proxy_name:
    config_target       => $config_target,
    ports               => $listen_port,
    default_remote_port => $remote_port,
    ipaddress           => $listen_address,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
