class twitch::haproxy::listeners::backend_countess (
  $haproxy_instance = 'backend',
  $proxy_name     = 'countess',
  $servers        = [
    'countess-48da57.sfo01.justin.tv',
    'countess-4e5a08.sfo01.justin.tv',
  ],
  $listen_port    = 12365,
  $remote_port    = 8081,
  $listen_address = '127.0.0.1',
  $server_options = 'check inter 5000',
  $settings       = {
    'mode'   => 'http',
    'option' => [
      'httpchk GET /debug/health',
    ]
  },
) {

  $countess = 'backend_countess'

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::listen{ $countess:
    config_target       => $config_target,
    ports               => $listen_port,
    default_remote_port => $remote_port,
    ipaddress           => $listen_address,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options
  }
}
