class twitch::haproxy::listeners::backend_database_sitedb_production_slave (
  $haproxy_instance = 'backend',
  $proxy_name     = 'database-sitedb-production-slave',
  $servers        = [],
  $listen_port    = 12006,
  $remote_port    = 6542,
  $listen_address = '127.0.0.1',
  $server_options = '',
  $settings       = {
    'default_backend' => 'database-93-slave'
  },
) {

  include twitch::haproxy::backends::database_93_slave

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::listen{ $proxy_name:
    config_target       => $config_target,
    ports               => $listen_port,
    default_remote_port => $remote_port,
    ipaddress           => $listen_address,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
