class twitch::haproxy::listeners::backend_discovery (
  $haproxy_instance = 'backend',
  $proxy_name     = 'discovery',
  $servers        = [
    'discovery-a0c34c.sfo01.justin.tv',
    'discovery-a0c35a.sfo01.justin.tv',
  ],
  $listen_port    = 12350,
  $remote_port    = 9292,
  $listen_address = '127.0.0.1',
  $server_options = 'check inter 5000',
  $settings       = {
    'mode'   => 'http',
    'option' => [
      'httpchk GET /',
    ]
  },
) {

  $discovery = 'backend_discovery'

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::listen{ $discovery:
    config_target       => $config_target,
    ports               => $listen_port,
    default_remote_port => $remote_port,
    ipaddress           => $listen_address,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options
  }
}
