class twitch::haproxy::listeners::backend_flowsd_mia02 (
  $haproxy_instance = 'backend',
  $proxy_name     = 'flowsd-mia02',
  $servers        = [
    'flowsd-6ecb18.sfo01.justin.tv:3700 port 37000 check inter 3000 fall 1',
    'flowsd5.sfo01.justin.tv:3800 port 38000 check inter 5000 backup',
  ],
  $listen_port    = 12326,
  $remote_port    = 3700,
  $listen_address = '127.0.0.1',
  $server_options = '',
  $settings       = {
    'no option' => [
      'allbackups'
    ],
    'option'    => [
      'httpchk HEAD /alive'
    ],
    'timeout' => [
      'queue 100ms'
    ],
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::listen{ $proxy_name:
    config_target       => $config_target,
    ports               => $listen_port,
    default_remote_port => $remote_port,
    ipaddress           => $listen_address,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
