class twitch::haproxy::listeners::backend_jax (
  $haproxy_instance = 'backend',
  $proxy_name     = 'jax',
  $servers        = [
    'jax1.sfo01.justin.tv',
    'jax2.sfo01.justin.tv',
    'jax3.sfo01.justin.tv',
    'jax4.sfo01.justin.tv',
  ],
  $listen_port    = 12305,
  $remote_port    = 8000,
  $listen_address = '127.0.0.1',
  $server_options = 'check inter 5000',
  $settings       = {
    'mode' => 'http',
    'option' => [
        'httpchk GET /debug/health',
    ]
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::listen{ $proxy_name:
    config_target       => $config_target,
    ports               => $listen_port,
    default_remote_port => $remote_port,
    ipaddress           => $listen_address,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
