class twitch::haproxy::listeners::backend_network_master (
  $haproxy_instance = 'backend',
  $proxy_name     = 'network-master',
  $servers        = [
    'usherdb-6db4a0.sfo01.justin.tv',
    'usherdb-6f4488.sfo01.justin.tv',
    'usherdb-7ecd3c.sfo01.justin.tv'
  ],
  $listen_port    = 12140,
  $remote_port    = 6544,
  $listen_address = '127.0.0.1',
  $server_options = 'check inter 2000',
  $settings       = {
    'maxconn' => 4000
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::listen{ $proxy_name:
    config_target       => $config_target,
    ports               => $listen_port,
    default_remote_port => $remote_port,
    ipaddress           => $listen_address,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
