class twitch::haproxy::listeners::backend_rabbit_cluster_video_production_http_api (
  $haproxy_instance = 'backend',
  $proxy_name     = 'rabbit-cluster-video-production-http-api',
  $servers        = [
    'rabbit4.sfo01.justin.tv',
    'rabbit5.sfo01.justin.tv',
  ],
  $listen_port    = 12196,
  $remote_port    = 15672,
  $listen_address = '127.0.0.1',
  $server_options = 'check inter 5000',
  $settings       = {
    'http-check' => 'expect status 200',
    'option'     => [
      'httpchk HEAD / HTTP/1.0\r\n'
    ],
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::listen{ $proxy_name:
    config_target       => $config_target,
    ports               => $listen_port,
    default_remote_port => $remote_port,
    ipaddress           => $listen_address,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
