class twitch::haproxy::listeners::backend_searchindexer (
  $haproxy_instance = 'backend',
  $proxy_name     = 'searchindexer',
  $servers        = [
    'siteinfra-searchindexer-001.sfo01.justin.tv',
    'siteinfra-searchindexer-002.sfo01.justin.tv',
  ],
  $listen_port    = 12360,
  $remote_port    = 9200,
  $listen_address = '127.0.0.1',
  $server_options = 'check inter 5000',
  $settings       = {
    'mode'   => 'http',
    'option' => [
      'httpchk GET /debug/health',
    ]
  },
) {

  $searchindexer = 'backend_searchindexer'

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::listen{ $searchindexer:
    config_target       => $config_target,
    ports               => $listen_port,
    default_remote_port => $remote_port,
    ipaddress           => $listen_address,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options
  }
}
