class twitch::haproxy::listeners::backend_static_jtvfs (
  $haproxy_instance = 'backend',
  $proxy_name     = 'static-jtvfs',
  $servers        = [
    'static4.sfo01.justin.tv',
    'static3.justin.tv',
  ],
  $listen_port    = 12235,
  $remote_port    = 4557,
  $listen_address = '127.0.0.1',
  $server_options = 'check inter 5000',
  $settings       = {
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::listen{ $proxy_name:
    config_target       => $config_target,
    ports               => $listen_port,
    default_remote_port => $remote_port,
    ipaddress           => $listen_address,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
