class twitch::haproxy::listeners::backend_tmi_event_api (
  $haproxy_instance = 'backend',
  $proxy_name     = 'tmi-event-api',
  $servers        = [
    'tmi-event-7dbb74.sfo01.justin.tv',
    'tmi-event-7eaa4c.sfo01.justin.tv',
    'tmi-event-a084c6.sfo01.justin.tv',
    'tmi-event-a0c3be.sfo01.justin.tv',
    'tmi-event-a0c5f0.sfo01.justin.tv',
  ],
  $listen_port    = 12381,
  $remote_port    = 6199,
  $listen_address = '127.0.0.1',
  $server_options = 'check inter 5000',
  $settings       = {
    'mode' => 'http',
    'option' => [
      'httpchk HEAD /debug/running',
    ]
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::listen{ $proxy_name:
    config_target       => $config_target,
    ports               => $listen_port,
    ipaddress           => $listen_address,
    default_remote_port => $remote_port,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
