class twitch::haproxy::listeners::backend_tmi_prod_api (
  $haproxy_instance = 'backend',
  $proxy_name     = 'tmi-prod-api',
  $servers        = [
    'tmi-main-6dbce8.sfo01.justin.tv',
    'tmi-main-7e8c7c.sfo01.justin.tv',
    'tmi-main-7e9188.sfo01.justin.tv',
    'tmi-main-7e9aac.sfo01.justin.tv',
    'tmi-main-7e9ab8.sfo01.justin.tv',
    'tmi-main-7e9e0c.sfo01.justin.tv',
    'tmi-main-7ea724.sfo01.justin.tv',
    'tmi-main-7eab84.sfo01.justin.tv',
    'tmi-main-7eab8c.sfo01.justin.tv',
    'tmi-main-7eabd0.sfo01.justin.tv',
    'tmi-main-a085e6.sfo01.justin.tv',
    'tmi-main-a0c416.sfo01.justin.tv',
  ],
  $listen_port    = 12380,
  $remote_port    = 6199,
  $listen_address = '127.0.0.1',
  $server_options = 'check inter 5000',
  $settings       = {
    'mode' => 'http',
    'option' => [
      'httpchk HEAD /debug/running',
    ]
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::listen{ $proxy_name:
    config_target       => $config_target,
    ports               => $listen_port,
    ipaddress           => $listen_address,
    default_remote_port => $remote_port,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
