class twitch::haproxy::listeners::backend_twitchtrace (
  $haproxy_instance = 'backend',
  $proxy_name     = 'twitchtrace',
  $servers        = [
    'tal1.sfo01.justin.tv',
  ],
  $listen_port    = 12310,
  $remote_port    = 11142,
  $listen_address = '127.0.0.1',
  $server_options = '',
  $settings       = {
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::listen{ $proxy_name:
    config_target       => $config_target,
    ports               => $listen_port,
    default_remote_port => $remote_port,
    ipaddress           => $listen_address,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
