class twitch::haproxy::listeners::backend_version (
  $haproxy_instance = 'backend',
  $proxy_name     = 'version-2014061902',
  $servers        = ['puppet.internal.justin.tv',
  ],
  $listen_port    = 11999,
  $remote_port    = 80,
  $listen_address = '127.0.0.1',
  $server_options = 'check inter 60000',
  $settings       = {
    'option'         => [
      'httpchk HEAD /2014061902 HTTP/1.0',
    ]
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::listen{ $proxy_name:
    config_target       => $config_target,
    ports               => $listen_port,
    default_remote_port => $remote_port,
    ipaddress           => $listen_address,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
