class twitch::haproxy::listeners::backend_videoshim (
  $haproxy_instance = 'backend',
  $proxy_name     = 'videoshim',
  $servers        = [
    'shim-493af0.sfo01.justin.tv:5151 port 35151 check inter 3000',
    'shim-493af8.sfo01.justin.tv:5151 port 35151 check inter 3000',
    'shim-4b5e40.sfo01.justin.tv:5151 port 35151 check inter 3000',
  ],
  $listen_port    = 12256,
  $listen_address = '127.0.0.1',
  $server_options = '',
  $settings       = {
    'option'    => [
      'httpchk HEAD /alive'
    ],
    'timeout' => [
      'queue 100'
    ],
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::listen{ $proxy_name:
    config_target       => $config_target,
    ports               => $listen_port,
    default_remote_port => $remote_port,
    ipaddress           => $listen_address,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
