class twitch::haproxy::listeners::backend_viewcount_usher (
  $haproxy_instance = 'backend',
  $proxy_name     = 'viewcount-usher',
  $servers        = [
    'viewcount1.sfo01.justin.tv',
    'viewcount2.sfo01.justin.tv',
  ],
  $listen_port    = 12290,
  $remote_port    = 8000,
  $listen_address = '127.0.0.1',
  $server_options = 'check port 8001 inter 5000',
  $settings       = {
    'option' => [
      'httpchk HEAD /alive'
    ],
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::listen{ $proxy_name:
    config_target       => $config_target,
    ports               => $listen_port,
    default_remote_port => $remote_port,
    ipaddress           => $listen_address,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
