class twitch::haproxy::listeners::backend_xbox_plsso_internal (
  $haproxy_instance = 'backend',
  $proxy_name     = 'xbox-plsso-internal',
  $servers        = [
    'platform-sso-6eadb0.sfo01.justin.tv',
    'platform-sso-6ea8f8.sfo01.justin.tv',
  ],
  $listen_port    = 12300,
  $remote_port    = 8080,
  $listen_address = '127.0.0.1',
  $server_options = 'check inter 5000',
  $settings       = {
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::listen{ $proxy_name:
    config_target       => $config_target,
    ports               => $listen_port,
    default_remote_port => $remote_port,
    ipaddress           => $listen_address,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
