class twitch::haproxy::listeners::hlsorigin_hls_reptree_origin (
  $haproxy_instance = 'hlsorigin',
  $proxy_name     = 'hls-reptree-origin',
  $servers        = [
    'hls64.sfo01.justin.tv check inter 3000 fall 1',
    'hls44.sfo01.justin.tv check inter 5000 backup',
    'hls34.sfo01.justin.tv check inter 5000 backup',
  ],
  $listen_port    = 12275,
  $remote_port    = 80,
  $listen_address = '127.0.0.1',
  $server_options = '',
  $settings       = {
    'option'        => [
      'httpchk HEAD /crossdomain.xml'
    ],
  },
) {

  $config_target = "/etc/haproxy/haproxy-${haproxy_instance}.conf"

  twitch_haproxy::listen{ $proxy_name:
    config_target       => $config_target,
    ports               => $listen_port,
    default_remote_port => $remote_port,
    ipaddress           => $listen_address,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
